<?php
function get_api_settings($pdo) {
    $stmt = $pdo->prepare("SELECT setting_key, setting_value FROM store_settings WHERE setting_key IN ('sms_api_key', 'sms_api_secret', 'email_api_key', 'email_api_secret', 'store_email', 'store_name', 'sms_sender_id', 'smtp_host', 'smtp_port', 'smtp_username', 'smtp_password', 'smtp_encryption')");
    $stmt->execute();
    $settings = [];
    while ($row = $stmt->fetch()) {
        $settings[$row['setting_key']] = $row['setting_value'];
    }
    return $settings;
}

function get_store_name($pdo) {
    $stmt = $pdo->prepare("SELECT setting_value FROM store_settings WHERE setting_key = 'store_name'");
    $stmt->execute();
    $result = $stmt->fetch();
    return $result ? $result['setting_value'] : 'Our Store';
}

function get_sms_settings($pdo) {
    $stmt = $pdo->prepare("SELECT setting_key, setting_value FROM store_settings WHERE setting_group = 'sms_settings'");
    $stmt->execute();
    $settings = [];
    while ($row = $stmt->fetch()) {
        $settings[$row['setting_key']] = $row['setting_value'];
    }
    return $settings;
}

function get_email_settings($pdo) {
    $stmt = $pdo->prepare("SELECT setting_key, setting_value FROM store_settings WHERE setting_group = 'email_settings'");
    $stmt->execute();
    $settings = [];
    while ($row = $stmt->fetch()) {
        $settings[$row['setting_key']] = $row['setting_value'];
    }
    return $settings;
}

function send_sms($phone, $message, $pdo) {
    try {
        // Log the attempt
        error_log("Attempting to send SMS to: " . $phone);
        $settings = get_sms_settings($pdo);
        
        if (empty($settings['sms_api_key']) || empty($settings['sms_api_secret']) || empty($settings['sms_sender_id'])) {
            return ['success' => false, 'error' => 'SMS settings not configured'];
        }

        // Here you would implement the actual SMS sending logic using your preferred SMS gateway
        // This is a placeholder example using cURL
        $url = 'https://api.smsgateway.com/send'; // Replace with your actual SMS gateway URL
        $data = [
            'api_key' => $settings['sms_api_key'],
            'api_secret' => $settings['sms_api_secret'],
            'sender_id' => $settings['sms_sender_id'],
            'phone' => $phone,
            'message' => $message
        ];

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);

        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($httpCode === 200) {
            return ['success' => true];
        } else {
            return ['success' => false, 'error' => 'Failed to send SMS'];
        }
    } catch (Exception $e) {
        error_log("SMS Error: " . $e->getMessage());
        return ['success' => false, 'error' => $e->getMessage()];
    }
}

function send_email($to, $subject, $message, $pdo) {
    try {
        // Log the attempt
        error_log("Attempting to send email to: " . $to);
        $settings = get_email_settings($pdo);
        
        if (empty($settings['smtp_host']) || empty($settings['smtp_port']) || 
            empty($settings['smtp_username']) || empty($settings['smtp_password'])) {
            return ['success' => false, 'error' => 'Email settings not configured'];
        }

        require_once __DIR__ . '/../vendor/autoload.php';

        $mail = new PHPMailer\PHPMailer\PHPMailer(true);
        
        // Server settings
        $mail->isSMTP();
        $mail->Host = $settings['smtp_host'];
        $mail->SMTPAuth = true;
        $mail->Username = $settings['smtp_username'];
        $mail->Password = $settings['smtp_password'];
        $mail->SMTPSecure = $settings['smtp_encryption'] ?? 'tls';
        $mail->Port = $settings['smtp_port'];

        // Recipients
        $mail->setFrom($settings['smtp_username'], get_store_name($pdo));
        $mail->addAddress($to);

        // Content
        $mail->isHTML(true);
        $mail->Subject = $subject;
        $mail->Body = $message;

        $mail->send();
        return ['success' => true];
    } catch (Exception $e) {
        error_log("Email Error: " . $e->getMessage());
        return ['success' => false, 'error' => $e->getMessage()];
    }
}

function test_email_settings($pdo) {
    $settings = get_email_settings($pdo);
    $to = $settings['smtp_username']; // Send to the same email
    $subject = 'Test Email from POS System';
    $message = 'This is a test email to verify your SMTP settings.';
    return send_email($to, $subject, $message, $pdo);
} 